<?php
if ($vbulletin->options['dbtech_vbsecurity_active'])
{
	$rules = array();
	foreach (array('passwordLength', 'containsLowerCase', 'containsUpperCase', 'containsNumbers', 'containsSymbols') as $rule)
	{
		if ($rule == 'passwordLength')
		{
			if (!$vbulletin->userinfo['permissions']['dbtech_vbsecurity_passwordlength'])
			{
				// Skip this
				continue;
			}

			// Now add the rule
			$rules[] = "passwordLength : {phrase : '" . construct_phrase($vbphrase['dbtech_vbsecurity_passwordrule_passwordlength'], $vbulletin->userinfo['permissions']['dbtech_vbsecurity_passwordlength']) . "', params : {passwordLength : " . $vbulletin->userinfo['permissions']['dbtech_vbsecurity_passwordlength'] . " }}";
		}
		else
		{
			$key = 'passwordrule_' . strtolower(substr($rule, strlen('contains')));		
			if (!($vbulletin->userinfo['permissions']['dbtech_vbsecuritypermissions'] & $vbulletin->bf_ugp_dbtech_vbsecuritypermissions[$key]))
			{
				// Skip this
				continue;
			}

			// Now add the rule
			$rules[] = "$rule : {phrase : '" . $vbphrase['dbtech_vbsecurity_' . $key] . "'}";
		}
	}

	$templater = vB_Template::create('dbtech_vbsecurity_passwordcheck');
		$templater->register('jQueryPath', 		VBSECURITY::jQueryPath());
		$templater->register('versionnumber', 	'118pl2');
		$templater->register('rules', 			implode(',', $rules));
	$footer .= $templater->render();
}
?>